﻿/* Skript zur Demonstration von Datumsfunktionen
 * Als Benutzer SCOTT ausführen
 */
 
 
-- Verwendung von sysdate und systimestamp
select sysdate, systimestamp
  from dual;

-- NLS-Parameter lesen und ändern
select *
  from v$nls_parameters
 where parameter = 'NLS_DATE_FORMAT';
 
alter session set nls_date_format = 'DD.MM.YYYY HH24:MI:SS';

select *
  from v$nls_parameters
 where parameter = 'NLS_DATE_FORMAT';
 
-- Abfrage der Zeitzone der Datenbank
select dbtimezone
  from dual;
  
-- Konvertierung einer Zeichenkette in ein Datum
select to_date('15.05.2012 17:30', 'dd.mm.yyyy hh24:mi') datum
  from dual;
  
-- Konvertierung eines Datums in eine Zeichenkette
select to_char(hiredate, 'dd.mm.yyyy') hiredate,
       to_char(sysdate, 'dd.mm.yyyy hh24:mi') heute,
       to_char(to_date('15.05.2012', 'dd.mm.yyyy'), 'yyyy/mm') monat
  from emp
 where empno = 7839;
 
-- Erzeugung von Intervallen mit Literalen
select interval '3-5' year to month jahr_monat,
       interval '36' month monate,
       interval '15' minute minuten,
       interval '4 3:20' day to minute tag
  from dual;
  
-- Erzeugung von Intervallen mit den Funktionen NUMTOYMINTERVAL und NUMTODSINTERVAL
select numtoyminterval(1.75, 'YEAR') jahr, 
       numtodsinterval(1.75, 'DAY') tag,
       numtodsinterval(
         sysdate - trunc(sysdate), 'Day') uhrzeit
  from dual;

-- Verwendung der Funktionen ROUND und TRUNC mit Datumsangaben
select trunc(sysdate) heute,
       trunc(sysdate, 'MM') erster_des_monats,
       round(sysdate, 'MM') gerundeter_monat
  from dual;
  
-- Verwendung der Funktion EXTRACT
select extract(year from sysdate) jahr,
       extract(month from hiredate) monat
  from emp
 where empno = 7839;
 
-- Verwendung der Funktion TO_CHAR als Ersatz für EXTRACT
select to_char(sysdate, 'yyyy')
  from dual;
  
-- Rechnen mit Intervallen
select trunc(sysdate) 
         + interval '3' month 
         + interval '1' day datum
  from dual;

select trunc(sysdate, 'MM') 
         + interval '1' month 
         + interval '3 15:30' day to minute datum
  from dual;
  
select trunc(sysdate)
         + interval '1 03:27:15' day to second datum
  from dual;
  
select trunc(sysdate)
         - interval '14' day datum
  from dual;
  
-- Subtraktion von Datumstypen
select sysdate - hiredate dauer
  from emp
 where empno = 7839;
 
select sysdate - trunc(sysdate) uhrzeit
  from dual;
  
select systimestamp - trunc(systimestamp) uhrzeit
  from dual;
  
-- Verwendung der Funktion ADD_MONTHS
select add_months(trunc(sysdate), 3) add_months,
       trunc(sysdate) + interval '3' month mit_interval
  from dual;
  
select add_months(trunc(sysdate), 3) add_months,
       add_months(trunc(sysdate), -3) subtract_months
  from dual;
       
-- Verwendung der Funktion MONTHS_BETWEEN
select ename, hiredate,
       trunc(months_between(sysdate, hiredate)/12) emp_alter
  from emp;
  
-- Verwendung der Funktion LAST_DAY
select last_day(sysdate) ultimo,
       extract(day from last_day(sysdate)) tage
  from dual;
  
-- Verwendung der Funktion NEXT_DAY
select next_day(sysdate, 'Montag')
  from dual;
